#!/bin/bash

if [ "$#" -ne 2 ]; then
    echo "Uso: $0 <Novo_IP> <Novo_Hostname>"
    exit 1
fi

NOVO_IP=$1
NOVO_HOSTNAME=$2
CONFIG_FILE="/etc/zabbix/zabbix_agent2.conf"

mkdir /zabbix_files

cd /zabbix_files
echo "Baixando Arquivos..."
wget https://git.usb.org.br/infra/zabbix/raw/master/zabbix_v2/Centos%206/agent2/zabbix-agent2-7.0.0-release1.el6.x86_64.rpm -P /zabbix_files



echo "instalando zabbix-agent2..."
yum -y install /zabbix_files/*.rpm

echo "Configurando..."
sed -i "s/^Server=.*/Server=$NOVO_IP/" "$CONFIG_FILE"
sed -i "s/^Hostname=.*/Hostname=$NOVO_HOSTNAME/" "$CONFIG_FILE"
sed -i "s/^ServerActive=.*/#&/" "$CONFIG_FILE"

echo "Configurações atualizadas com sucesso no arquivo $CONFIG_FILE:"
echo "Server=$NOVO_IP"
echo "Hostname=$NOVO_HOSTNAME"

mkdir -p /run/zabbix/
chown zabbix. /run/zabbix

service zabbix-agent2 start
chkconfig zabbix-agent2 on
echo "Instalação Concluida"

